<?php
/**
 * Plugin Name: Hide Posts
 * Plugin URI: https://plugins.kddev.co.uk/kdweb-hide-posts/
 * Description: Hide posts UI in the admin if the site does not have a blog.
 * Version: 1.0.0
 * Author: KD Web
 * Author URI: https://www.kddev.co.uk
 * Requires at least: 6.0.0
 * Requires PHP: 8.0.0
 *
 * @package KDWeb\Plugin\HidePosts
 */

namespace KDWeb\Plugin\HidePosts;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Unregister default taxonomies from Posts
 *
 * @return void
 */
function unregister_default_taxonomy() {
	unregister_taxonomy_for_object_type( 'category', 'post' );
	unregister_taxonomy_for_object_type( 'post_tag', 'post' );
}
add_action( 'init', 'KDWeb\Plugin\HidePosts\unregister_default_taxonomy' );

/**
 * Change access capabilities for posts
 *
 * @param array  $args The post type arguments.
 * @param string $name The post type slug.
 * @return array
 */
function change_access_caps( $args, $name ) {
	if ( 'post' === $name ) {
		$args['map_meta_cap'] = false;
		$args['public']       = false;
		$args['capabilities'] = array(
			'edit_post'              => '',
			'read_post'              => '',
			'delete_post'            => '',
			'edit_posts'             => '',
			'edit_others_posts'      => '',
			'publish_posts'          => '',
			'read_private_posts'     => '',
			'read'                   => '',
			'delete_posts'           => '',
			'delete_private_posts'   => '',
			'delete_published_posts' => '',
			'delete_others_posts'    => '',
			'edit_private_posts'     => '',
			'edit_published_posts'   => '',
			'create_posts'           => '',
		);
	}
	return $args;
}
add_filter( 'register_post_type_args', 'KDWeb\Plugin\HidePosts\change_access_caps', PHP_INT_MAX, 2 );

/**
 * Check for plugin updates.
 *
 * @param object $transient The transient object.
 * @return object The updated transient object.
 */
function check_plugin_update( $transient ) {
	$current_version = get_file_data( __FILE__, array( 'Version' => 'Version' ) )['Version'];
	$plugin_info = json_decode(
		wp_remote_retrieve_body(
			wp_remote_get( 'https://plugins.kddev.co.uk/kdweb-hide-posts/update' )
		),
		true
	);
	if ( $plugin_info && ! is_wp_error( $plugin_info ) && version_compare( $plugin_info['new_version'], $current_version, '>' ) ) {
		$transient->response['kdweb-hide-posts/kdweb-hide-posts.php'] = (object) $plugin_info;
	}
	$transient->no_update['kdweb-hide-posts/kdweb-hide-posts.php'] = (object) array(
		'id'            => 'kdweb-hide-posts/kdweb-hide-posts.php',
		'slug'          => 'kdweb-hide-posts',
		'plugin'        => 'kdweb-hide-posts/kdweb-hide-posts.php',
		'new_version'   => get_file_data( __FILE__, array( 'Version' => 'Version' ) )['Version'],
		'url'           => '',
		'package'       => '',
		'icons'         => array(),
		'banners'       => array(),
		'banners_rtl'   => array(),
		'tested'        => '',
		'requires_php'  => '',
		'compatibility' => new \stdClass(),
	);
	return $transient;
}
add_filter( 'pre_set_site_transient_update_plugins', 'KDWeb\Plugin\HidePosts\check_plugin_update' );

/**
 * Get plugin information from the plugin server.
 *
 * @param bool   $result The default value.
 * @param string $action The action to perform.
 * @param object $args The arguments for the action.
 * @return object|bool The plugin information or false.
 */
function plugin_info( $result, $action, $args ) {
	if ( 'plugin_information' === $action && 'kdweb-hide-posts' === $args->slug ) {
		$plugin_info = json_decode(
			wp_remote_retrieve_body(
				wp_remote_get( 'https://plugins.kddev.co.uk/kdweb-hide-posts/info' )
			),
			true
		);
		if ( ! $plugin_info || is_wp_error( $plugin_info ) ) {
			return $result;
		}
		return (object) $plugin_info;
	}
	return $result;
}
add_filter( 'plugins_api', 'KDWeb\Plugin\HidePosts\plugin_info', 10, 3 );
