<?php
/**
 * Add logo and site icon settings to general settings
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }


/**
 * Register logo and icon settings
 *
 * @return void
 */
function register_logo_settings() {
	if ( get_option( 'kdweb_admin_setup_logo_settings_logo', true ) ) {
		register_setting( 'general', 'kdweb-site-logo', array(
			'type'              => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => '',
		) );
		add_settings_field(
			'kdweb-site-logo',
			'Site Logo',
			'KDWeb\Plugin\Admin\render_logo_field',
			'general',
			'default',
			array( 'option_name' => 'kdweb-site-logo' )
		);
	}

	if ( get_option( 'kdweb_admin_setup_logo_settings_icon', false ) ) {
		register_setting( 'general', 'kdweb-site-icon', array(
			'type'              => 'string',
			'sanitize_callback' => 'sanitize_text_field',
			'default'           => '',
		) );
		add_settings_field(
			'kdweb-site-icon',
			'Site Icon',
			'KDWeb\Plugin\Admin\render_icon_field',
			'general',
			'default',
			array( 'option_name' => 'kdweb-site-icon' )
		);
	}
}

/**
 * Render logo field
 *
 * @param array $args Field arguments.
 * @return void
 */
function render_logo_field( $args ) {
	$value = get_option( $args['option_name'], '' );
	echo '<input type="text" name="' . esc_attr( $args['option_name'] ) . '" value="' . esc_attr( $value ) . '" class="regular-text" />';
	echo '<p class="description">Enter the attachment ID of the logo image.</p>';
}

/**
 * Render icon field
 *
 * @param array $args Field arguments.
 * @return void
 */
function render_icon_field( $args ) {
	$value = get_option( $args['option_name'], '' );
	echo '<input type="text" name="' . esc_attr( $args['option_name'] ) . '" value="' . esc_attr( $value ) . '" class="regular-text" />';
	echo '<p class="description">Enter the attachment ID of the site icon image.</p>';
}

/**
 * Change placement of fields on the general settings page so that site logo and site icon can move up the list
 *
 * @return void
 */
function logo_settings_placement() {
    $screen = get_current_screen();
    if ( ! $screen || ! $screen->id || 'options-general' !== $screen->id ) {
        return;
    }
    wp_enqueue_style(
        'kdweb-logo-settings-placement',
        plugin_dir_url( dirname( __FILE__ ) ) . 'assets/logo-settings-placement.css',
        array(),
        false,
        'all'
    );
}

/**
 * Update core site icon settings when kdweb site icon is changed
 *
 * @return void
 */
function logo_settings_save_icon() {
    global $pagenow;
    if ( ! $pagenow || 'options.php' !== $pagenow || empty( $_POST ) ) {
        return;
    }
    $icon = isset( $_POST['kdweb-site-icon'] ) ? sanitize_text_field( $_POST['kdweb-site-icon'] ) : '';
    update_option( 'site_icon', $icon );
}
