<?php
/**
 * Setup the Launchpad widget to the admin dashboard
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Register the dashboard widget
 *
 * @return void
 */
function register_kdweb_dashboard_launchpad_widget() {
	wp_add_dashboard_widget(
		'kdweb-dashboard-launchpad',
		__( 'Launchpad' ),
		'KDWeb\Plugin\Admin\the_dashboard_launchpad_widget_content',
		null,
		null,
		'side',
		'default'
	);
}

/**
 * Display the dashboard widget content
 *
 * @return void
 */
function the_dashboard_launchpad_widget_content() {
	include plugin_dir_path( dirname( __FILE__ ) ) .  'assets/launchpad-widget.php';
}

/**
 * Return the site logo (or the kd web logo as a fallback)
 *
 * @param string|array $size The image size (registered or array).
 * @param array        $attr The HTML attributes of the image.
 * @return void
 */
function the_site_logo( $size = 'full', $attr = array() ) {
	echo wp_get_attachment_image( get_option( 'kdweb-site-logo' ), $size, false, $attr );
}

/**
 * Add widget styles to dashboard
 *
 * @return void
 */
function dashboard_launchpad_styles() {
    $screen = get_current_screen();
    if ( ! $screen || ! $screen->id || 'dashboard' !== $screen->id ) {
        return;
    }
    wp_enqueue_style(
        'kdweb-launchpad-widget',
        plugin_dir_url( dirname( __FILE__ ) ) . 'assets/launchpad-widget.css',
        array(),
        false,
        'all'
    );
}
