<?php
/**
 * Setup the Info widget to the admin dashboard
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Register the dashboard widget
 *
 * @return void
 */
function register_kdweb_dashboard_info_widget() {
	wp_add_dashboard_widget(
		'kdweb-dashboard-info',
		__( 'System Information' ),
		'KDWeb\Plugin\Admin\the_dashboard_info_widget_content',
		null,
		null,
		'column3',
		'default'
	);
}

/**
 * Display the dashboard widget content
 *
 * @return void
 */
function the_dashboard_info_widget_content() {
	include plugin_dir_path( dirname( __FILE__ ) ) . 'assets/info-widget.php';
}

/**
 * Convert a version integer to a string
 *
 * @param int $version The version integer.
 * @return string The version string.
 */
function version_int_to_str( $version ) {
	$major = floor( $version / 10000 );
	$version -= $major * 10000;
	$minor = floor( $version / 100 );
	$version -= $minor * 100;
	$patch = str_pad( $version, 2, '0', STR_PAD_LEFT );
	$patch = '00' === $patch ? '' : ".{$patch}";
	return "{$major}.{$minor}{$patch}";
}

/**
 * Add widget styles to dashboard
 *
 * @return void
 */
function dashboard_info_styles() {
    $screen = get_current_screen();
    if ( ! $screen || ! $screen->id || 'dashboard' !== $screen->id ) {
        return;
    }
    wp_enqueue_style(
        'kdweb-dashboard-info',
        plugin_dir_url( dirname( __FILE__ ) ) . 'assets/info-widget.css',
        array(),
        false,
        'all'
    );
}
