<?php
/**
 * Customize the login page with the project logo and custom colour
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Add custom project logo to the login page
 *
 * @return void
 */
function add_login_logo() {
    $logo = apply_filters( 'kdweb_login_logo', get_option( 'kdweb-site-logo' ) );
    if ( ! $logo || empty( $logo ) ) {
        return;
    }
	$logo = is_numeric( $logo ) ? wp_get_attachment_image_src( $logo, apply_filters( 'kdweb_login_logo_size', 'full' ) ) : $logo;
    if ( is_array( $logo ) ) {
		$logo = $logo[0];
	}
	if ( ! $logo || empty( $logo ) ) {
        return;
    }
    wp_add_inline_style(
        'login',
        ".login h1 a{background-image:url({$logo});background-size:contain;width:auto}"
    );
}

/**
 * Add custom color for the login page
 *
 * @return void
 */
function add_login_color() {
	$color = get_option( 'kdweb_admin_setup_customized_login_page_color', '' );
	if ( empty( $color ) ) {
		return;
	}

	// Support for color array (main, hover, active) or single color string
	if ( is_array( $color ) ) {
		$main_color   = $color[0] ?? '';
		$hover_color  = $color[1] ?? $main_color;
		$active_color = $color[2] ?? $hover_color;
	} else {
		$main_color   = $color;
		$hover_color  = $color;
		$active_color = $color;
	}

	$encoded_color = urlencode( $main_color );
    wp_add_inline_style(
        'login',
        ".login #nav a:hover,.login #backtoblog a:hover,.login h1 a:hover,.login #nav a:focus,.login #backtoblog a:focus,.login h1 a:focus{color:{$main_color}}a:focus{box-shadow: 0 0 5px 1px {$main_color}}.wp-core-ui .button-primary,.wp-core-ui .button.button-large,.wp-core-ui .button-group.button-large .button{background:{$main_color};border-color:currentcolor;color:white}.wp-core-ui .button-primary:hover, .wp-core-ui .button-primary.hover, .wp-core-ui .button-primary:focus, .wp-core-ui .button-primary.focus,.wp-core-ui .button.button-large:hover,.wp-core-ui .button.button-large.hover,.wp-core-ui .button.button-large:focus,.wp-core-ui .button.button-large.focus,.wp-core-ui .button-group.button-large .button:hover,.wp-core-ui .button-group.button-large .button.hover,.wp-core-ui .button-group.button-large .button:focus,.wp-core-ui .button-group.button-large .button.focus{background:{$hover_color};border-color:currentcolor;color:white}.wp-core-ui .button-primary:active,.wp-core-ui .button-primary.active,.wp-core-ui .button.button-large:active,.wp-core-ui .button.button-large.active,.wp-core-ui .button-group.button-large .button:active,.wp-core-ui .button-group.button-large .button.active{background:{$active_color};border-color:currentcolor;color:white}.wp-core-ui .button,.wp-core-ui .button-secondary{border-color:currentcolor;color:currentcolor;transition:background-color 0.3s ease-in-out}.wp-core-ui .button:hover, .wp-core-ui .button.hover,.wp-core-ui .button-secondary:hover,.wp-core-ui .button-secondary.hover{border-color:{$main_color};color:{$main_color}}input[type=text]:focus,input[type=password]:focus,input[type=color]:focus,input[type=date]:focus,input[type=datetime]:focus,input[type=datetime-local]:focus,input[type=email]:focus,input[type=month]:focus,input[type=number]:focus,input[type=search]:focus,input[type=tel]:focus,input[type=time]:focus,input[type=url]:focus,input[type=week]:focus,input[type=checkbox]:focus,input[type=radio]:focus,select:focus,textarea:focus,.wp-core-ui select:focus,.wp-core-ui .button.focus,.wp-core-ui .button:focus,.wp-core-ui .button-secondary:focus,.login .button.wp-hide-pw:focus{border-color:{$main_color};box-shadow:0 0 0 1px {$main_color}}.wp-core-ui select:hover{color:{$main_color}}input[type=checkbox]:checked::before{content:url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20'%3E%3Cpath d='M14.83 4.89l1.34.94-5.81 8.38H9.02L5.78 9.67l1.34-1.25 2.57 2.4z' fill='{$encoded_color}'/%3E%3C/svg%3E\")}"
    );
}
