<?php
/**
 * Load jQuery from a CDN instead of from the wp-includes folder
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Add prefetch tags to the head for the jquery cdn
 *
 * @param array  $urls An array of URLs.
 * @param string $relation The relationship type.
 * @return array
 */
function load_jquery_from_cdn_prefetch( $urls, $relation ) {
    if ( 'dns-prefetch' === $relation && wp_script_is( 'jquery' ) ) {
        $urls[] = 'code.jquery.com';
    }
    return $urls;
}

/**
 * Change registered jquery
 *
 * @return void
 */
function load_jquery_from_cdn_reregister_jquery() {
    $jquery_version         = wp_scripts()->registered['jquery']->ver;
    $jquery_version         = str_replace( '-wp', '', $jquery_version );
    $jquery_migrate_version = wp_scripts()->registered['jquery-migrate']->ver;
    wp_deregister_script( 'jquery' );
    wp_register_script(
        'jquery',
        'https://code.jquery.com/jquery-' . $jquery_version . '.min.js',
        array(),
        '1.0.0',
        true
    );
    wp_deregister_script( 'jquery-migrate' );
    wp_register_script(
        'jquery-migrate',
        'https://code.jquery.com/jquery-migrate-' . $jquery_migrate_version . '.min.js',
        array( 'jquery-core' ),
        '1.0.0',
        true
    );
}
