<?php
/**
 * Disable the JSON REST API (by default only for unauthenticated visitors)
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Initialize JSON API disabling for unauthenticated users
 *
 * @return void
 */
function init_disable_json_api() {
	if ( is_user_logged_in() ) {
		return;
	}
	// Check if this is a LiteSpeed token request
	if ( isset( $_SERVER['REQUEST_URI'] ) && strpos( $_SERVER['REQUEST_URI'], '/wp-json/litespeed/v1/token' ) !== false ) {
		return;
	}
	remove_action( 'xmlrpc_rsd_apis', 'rest_output_rsd' );
	remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
	remove_action( 'template_redirect', 'rest_output_link_header', 11 );
	add_filter( 'rest_authentication_errors', 'KDWeb\Plugin\Admin\disable_json_api_return_api_error', 20 );
	add_filter( 'site_status_tests', 'KDWeb\Plugin\Admin\disable_json_api_filter_out_site_health_check' );
}

/**
 * Deny access to the API
 *
 * @return \WP_Error
 */
function disable_json_api_return_api_error() {
    return new \WP_Error(
        'api_access_denied',
        __( 'No unauthorised access to the REST API.', 'default' ),
        array( 'status' => rest_authorization_required_code() )
    );
}

/**
 * Remove API test from the health check
 *
 * @param array $tests An array of the tests to run.
 * @return array
 */
function disable_json_api_filter_out_site_health_check( array $tests ) {
    unset( $tests['direct']['rest_availability'] );
    return $tests;
}
