<?php
/**
 * Disable RSS, RSS2, Atom and RDF feeds functionality
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Kill page when system tries to load a feed
 *
 * @return void
 */
function disable_feeds_kill_when_feed() {
    wp_die(
        esc_html__( 'Page not found' ),
        esc_html__( 'Page not found' ),
        array( 'response' => 404 )
    );
}

/**
 * Remove feed rewrites from permalinks
 *
 * @return void
 */
function disable_feeds_remove_feed_rewrites() {
    global $wp_rewrite;

    $wp_rewrite->feeds     = array();
    $wp_rewrite->feed_base = '';
    foreach ( $wp_rewrite->extra_permastructs as &$permastruct ) {
        $permastruct['feed'] = false;
    }
}
