<?php
/**
 * Remove Customizer support thoroughly
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Add filter on init
 *
 * @return void
 */
function disable_customizer_frontend() {
    add_filter( 'map_meta_cap', 'KDWeb\Plugin\Admin\disable_customizer_remove_meta_cap', 10, 2 );
}

/**
 * Remove capability to customize
 *
 * @param array  $caps The array of capabilites to filter.
 * @param string $cap The current capability being checked.
 * @return array
 */
function disable_customizer_remove_meta_cap( $caps = array(), $cap = '' ) {
    if ( 'customize' === $cap ) {
        return array( 'none' );
    }
    return $caps;
}

/**
 * Add hooks on admin init
 *
 * @return void
 */
function disable_customizer_admin() {
    remove_action( 'plugins_loaded', '_wp_customize_include', 10 );
    remove_action( 'admin_enqueue_scripts', '_wp_customize_loader_settings', 11 );
    add_action( 'load-customize.php', 'KDWeb\Plugin\Admin\disable_customizer_admin_page' );
}

/**
 * Override default load for load-customize.php return
 *
 * @return void
 */
function disable_customizer_admin_page() {
    wp_die(
        esc_html(
            __(
                'The Customizer is currently disabled.',
                'kdweb'
            )
        )
    );
}
