<?php
/**
 * Remove css and js file versioning (suffix ?ver=1.0.0) on the front-end
 *
 * @package KDWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

if ( ! defined( 'ABSPATH' ) ) { exit; }

/**
 * Remove file version from files
 *
 * @param string $src The script or style url.
 * @return string
 */
function disable_asset_version( $src ) {
    if ( is_admin() || ! $src ) {
        return $src;
    }
    return esc_url( remove_query_arg( 'ver', $src ) );
}

/**
 * Remove file version from files if they are certainly added automatically
 * Does not remove manually set version numbers
 *
 * @param string $src The script or style url.
 * @return string
 */
function disable_automatic_asset_version( $src ) {
    global $wp_version;
    if ( is_admin() || ! $src || ! strstr( $src, "ver={$wp_version}" ) ) {
        return $src;
    }
    return esc_url( remove_query_arg( 'ver', $src ) );
}
