<?php
/**
 * Content for kdweb branded dashboard widget
 *
 * @package KdWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

$post_types = array_filter(
	array_map(
		fn( $post_type ) => array(
			'post_type' => $post_type,
			'title'     => get_post_type_object( $post_type )->labels->name,
			'icon'      => get_post_type_object( $post_type )->menu_icon ?? 'dashicons-admin-post',
			'link'      => admin_url( 'post' === $post_type ? 'edit.php' : 'edit.php?post_type=' . $post_type ),
			'hidden'    => empty( get_post_type_object( $post_type )->cap->edit_posts ),
			'count'     => wp_count_posts( $post_type )->publish
		),
		apply_filters(
			'kdweb_dashboard_widget_post_types',
			array_merge(
				array( 'post', 'page', 'attachment' ),
				array_filter(
					array_keys(
						get_post_types( array( 'show_ui' => true, '_builtin' => false ) )
					),
					fn( $post_type ) => ! str_starts_with( $post_type, 'acf-' ) && ! str_starts_with( $post_type, 'woo' ) && current_user_can( get_post_type_object( $post_type )->cap->edit_posts )
				)
			)
		)
	),
	fn( $post_type ) => ! $post_type['hidden']
);

?>
<div class="kdweb-launchpad-widget">
	<?php the_site_logo(); ?>
	<h3><strong><?php bloginfo( 'title' ); ?></strong></h3>
	<ul>
		<?php
		foreach ( $post_types as $post_type ) {
			?>
			<li>
				<a href="<?php echo $post_type['link']; ?>">
					<span class="dashicons <?php echo $post_type['icon']; ?>"></span>
					<?php
					echo 0 === $post_type['count'] ? '' : $post_type['count'] . ' ';
					echo $post_type['title'];
					?>
				</a>
			</li>
			<?php
		}
		?>
	</ul>
</div>
