<?php
/**
 * Content for kdweb info widget
 *
 * @package KdWeb\Plugin\Admin
 */

namespace KDWeb\Plugin\Admin;

global $wp_version, $wpdb;

require_once ABSPATH . 'wp-admin/includes/translation-install.php';

$mysql = mysqli_init();
mysqli_real_connect( $mysql, DB_HOST, DB_USER, DB_PASSWORD );
$mysql_system = strstr( mysqli_get_server_info( $mysql ), 'MariaDB' ) ? 'MariaDB' : 'MySQL';
$mysql_logo = 'MariaDB' === $mysql_system ? 'mariadb-logo' : 'mysql-logo';
$mysql_version = version_int_to_str( mysqli_get_server_version( $mysql ) );

$connection_secure = ! empty( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] !== 'off' || isset( $_SERVER['REQUEST_SCHEME'] ) && $_SERVER['REQUEST_SCHEME'] == 'https';

$current_theme = wp_get_theme();
$theme_author = $current_theme->get('Author');
$is_kdweb_theme = ( $theme_author === 'KD Web' );
?>
<div class="kdweb-info-widget">
	<img src="<?php echo plugin_dir_url( dirname( __FILE__ ) ) . 'assets/wp-logo.svg'; ?>" alt="WordPress logo">
	<h3><strong>WordPress</strong> <?php echo $wp_version; ?></h3>
	<ul>
		<li>
			<?php if ( $is_kdweb_theme ) : ?>
				<img src="<?php echo plugin_dir_url( dirname( __FILE__ ) ) . 'assets/kdweb-logo.svg'; ?>" alt="Kd Web logo">
				Theme by KD Web
			<?php else : ?>
				<img src="<?php echo $current_theme->get_screenshot(); ?>" alt="<?php echo esc_attr( $current_theme->get('Name') ); ?> screenshot" style="max-width: 50px; height: auto;">
				Theme by <?php echo esc_html( str_replace( 'the WordPress team', 'WordPress', $theme_author ) ); ?>
			<?php endif; ?>
		</li>
		<li>
			<span class="dashicons dashicons-admin-plugins"></span>
			<?php echo count( wp_get_active_and_valid_plugins() ); ?>
			active plugins
		</li>
		<li>
			<span class="dashicons <?php echo $connection_secure ? 'dashicons-privacy' : 'dashicons-shield-alt'; ?>"></span>
			<?php echo $connection_secure ? 'secure connection' : 'http connection'; ?>
		</li>
		<li>
			<span class="dashicons dashicons-translation"></span>
			<?php echo wp_get_available_translations()[ get_locale() ]['native_name']; ?>
		</li>
		<li>
			<img src="<?php echo plugin_dir_url( dirname( __FILE__ ) ) . 'assets/php-logo.svg'; ?>" alt="PHP logo">
			version <?php echo phpversion(); ?>
		</li>
		<li>
			<img src="<?php echo plugin_dir_url(  dirname( __FILE__ ) ) . "assets/{$mysql_logo}.svg"; ?>" alt="Database logo">
			version <?php echo $mysql_version; ?>
		</li>
	</ul>
</div>
