(function() {
    if (!window.wp || !wp.data || !wp.blocks) {
        return;
    }

    // Wait for blocks to be registered
    wp.domReady(function() {
        setTimeout(function() {
            const blockTypes = wp.data.select('core/blocks').getBlockTypes();
            const blocks = blockTypes.map(block => ({
                name: block.name,
                title: block.title
            }));

            // Send block data to server
            wp.apiFetch({
                path: '/kdweb/v1/cache-block-types',
                method: 'POST',
                data: { blocks: blocks }
            });
        }, 1000); // Small delay to ensure all blocks are registered
    });
})();
